brontosaurus = {}
function brontosaurus.OnLevelInit(self)
	self.Crankiness = { 6000, 6000, 6000, 6000, 6000, 3000 };
	self.TransitionDuration = 800;
	self.CrankyLevel = 0;
	self.CrankyTimer = self.Crankiness[1];
	self.TransitionTimer = self.TransitionDuration;
	self:PlayAnim("tail_left", "Wag");
	self:PlayAnim("hearts", "Heart".. tostring(5-self.CrankyLevel));
	self:PlayAnim("head", "Annoyed");
	self:PlayAnim("foot", "Pleasant");
end

function brontosaurus.OnEnter(self, flo)
	self.CrankyLevel = 0;
	self.CrankyTimer = self.Crankiness[1];	
	DebugOut("Flo Entered the station!");
	self:PlayAnim("head", "Pleasant");
	self:PlayAnim("tail_left", "HappyWag");
	self:PlayAnim("hearts", "Heart5");
	self.TransitionTimer = self.TransitionDuration;
	gamedata.DoHeartBoost( self.location[1], self.location[2] );
end

function brontosaurus.OnUpdate(self, elapsedTime)
	-- Deal with the timers, one for transitions between states of crankiness and
	-- the other for the levels of crankiness themselves
	self.TransitionTimer = self.TransitionTimer - elapsedTime;
	if (self.TransitionTimer <= 0) then
		gamedata.EndShake();
		-- Deal with levels of general crankiness
		self.CrankyTimer = self.CrankyTimer - elapsedTime;
		self:PlayAnim("hearts", "Heart".. tostring(5-self.CrankyLevel));
		
		if (self.CrankyTimer <= 0) then
			self.CrankyLevel = self.CrankyLevel + 1;
			newval = self.Crankiness[self.CrankyLevel];
			if ( not(newval == nil) ) then
				self.CrankyTimer = newval;
			end		

			self:PlayAnim("tail_left", "Wag");
			
			-- Deal with transitions
			if (self.CrankyLevel >= 6) then
				self:PlayAnim("head", "Annoyed");
				self:PlayAnim("foot", "Pleasant");
				self.CrankyLevel = 0;
			elseif (self.CrankyLevel >= 5) then
				self:PlayAnim("foot", "Mad");				
				gamedata.StartShake();
			elseif (self.CrankyLevel >= 4) then
				self:PlayAnim("head", "Mad");
			elseif (self.CrankyLevel >= 3) then
				self:PlayAnim("head", "Ticked");
			elseif (self.CrankyLevel >= 2) then
				self:PlayAnim("head", "Annoyed");
			end
						
			DebugOut("CrankyLevel is now "  .. tostring(self.CrankyLevel) .. ", head animation is now " .. tostring(self.activeAnimations["head"]));
			
			self.TransitionTimer = self.TransitionDuration;		
		end
	end		
end
